#ifndef TEXTURE_H_
#define TEXTURE_H_

#include <string>
#include "image.h"

struct HitPoint;

class Texture {
public:
	enum class SampleMode { nearest, linear };
	enum class WrapMode { clamp, repeat };

protected:
	std::string name;

	SampleMode sampling;
	WrapMode wrapping;

public:
	Texture();
	virtual ~Texture();

	virtual void set_name(const char *name);
	virtual const char *get_name() const;

	virtual void set_sampling_mode(SampleMode mode);
	virtual SampleMode get_sampling_mode() const;
	virtual void set_wrapping_mode(WrapMode mode);
	virtual WrapMode get_wrapping_mode() const;

	virtual bool load(const char *fname) = 0;

	virtual Color sample(float u, float v, float w) const = 0;
	virtual Color sample(const HitPoint &hit) const;
};

class Texture2D : public Texture {
private:
	Image img;

public:
	virtual bool load(const char *fname);

	virtual Color sample(float u, float v, float w) const;

	friend Texture *load_texture(const char *fname);
};

class TextureCube : public Texture {
private:
	Image img[6];

public:
	TextureCube();

	virtual bool load(const char *fname);

	virtual Color sample(float u, float v, float w) const;
	virtual Color sample(const HitPoint &hit) const;

	friend Texture *load_texture(const char *fname);
};

Texture *load_texture(const char *fname);

#endif	// TEXTURE_H_
