#ifndef REND_H_
#define REND_H_

#include "scene.h"

bool init_renderer(Scene *scn, int xsz, int ysz);
void destroy_renderer();

void set_render_samples(int samples);

void resize_renderer(int xsz, int ysz);

float *render_frame(long msec);

Color trace_ray(const Scene *scn, const Ray &ray, int rdepth = 0);
Color shade(const Scene *scn, const Ray &ray, const HitPoint &hit, int rdepth);

#endif	// REND_H_
