/*
Simple introductory ray tracer
Copyright (C) 2012  John Tsiombikas <nuclear@member.fsf.org>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef PLANE_H_
#define PLANE_H_

#include "vmath/vmath.h"
#include "object.h"

class Plane : public Object {
public:
	Vector3 normal;
	float dist;

	Plane();
	Plane(const Vector3 &norm, float dist);

	bool intersect(const Ray &ray, HitPoint *pt) const;
};

#endif	// PLANE_H_
