/*
Simple introductory ray tracer
Copyright (C) 2012  John Tsiombikas <nuclear@member.fsf.org>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef OBJECT_H_
#define OBJECT_H_

#include "vmath/vmath.h"
#include "material.h"
#include "xform_node.h"

struct HitPoint;

class Object : public XFormNode {
public:
	Matrix4x4 xform, inv_xform, dir_xform;

	Material material;		// surface material properties

	virtual ~Object() {}

	virtual void prepare_xform(long msec);

	virtual bool intersect(const Ray &ray, HitPoint *pt) const = 0;
};

struct HitPoint {
	float dist;       // parametric distance of intersection along the ray
	Vector3 pos;       // world position of the intersection point
	Vector3 normal;    // surface normal vector at the intersection point
	Vector2 texcoord;  // texture coordinates at the intersection point
	const Object *obj; // pointer to the intersected object
};

#endif	// OBJECT_H_
