/*
Simple introductory ray tracer
Copyright (C) 2012  John Tsiombikas <nuclear@member.fsf.org>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MATERIAL_H_
#define MATERIAL_H_

#include "vmath/vmath.h"

// colors are simply RGB vectors
typedef Vector3 Color;

class Texture;

class Material {
public:
	// phong model parameters
	Color diffuse;    // amount of diffuse light scattering (per color channel)
	Color specular;   // amount of specular light reflection (per color channel)
	float shininess;  // higher shininess values -> more focused specular refl.

	Color emission;   // emissive light

	// additional raytracing parameters
	float reflectivity; // range [0, 1]
	float transparency; // range [0, 1]
	float ior;          // index of refraction

	Texture *tex;

	Material();
	Material(const Color &dcol, const Color &scol = Color(1.0, 1.0, 1.0), float spow = 60.0,
			float refl = 0.0, float refr = 0.0, float ior = 1.0);
};

#endif	// MATERIAL_H_
