/*
Simple introductory ray tracer
Copyright (C) 2012  John Tsiombikas <nuclear@member.fsf.org>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "material.h"

Material::Material()
	: diffuse(1.0, 1.0, 1.0), specular(0.0, 0.0, 0.0)
{
	shininess = 60.0;
	reflectivity = 0.0;
	transparency = 0.0;
	ior = 1.0;

	tex = 0;
}

Material::Material(const Color &dcol, const Color &scol, float spow,
		float refl, float refr, float ior)
	: diffuse(dcol), specular(scol)
{
	shininess = spow;
	reflectivity = refl;
	transparency = refr;
	this->ior = ior;

	tex = 0;
}
