#include <stdio.h>
#include <string.h>
#include <errno.h>
#include "image.h"
#include "material.h"
#include <imago2.h>

Image::Image()
{
	pixels = 0;
	xsz = ysz = 0;
}

Image::Image(int xsz, int ysz)
{
	pixels = 0;
	set_pixels(xsz, ysz, 0);
}

Image::~Image()
{
	delete [] pixels;
}

void Image::set_pixels(int xsz, int ysz, const Color *pix)
{
	delete [] pixels;

	pixels = new Color[xsz * ysz];
	this->xsz = xsz;
	this->ysz = ysz;

	if(pix) {
		memcpy(pixels, pix, xsz * ysz * sizeof *pixels);
	}
}

bool Image::load(const char *fname)
{
	int xsz, ysz;
	Color *img = (Color*)img_load_pixels(fname, &xsz, &ysz, IMG_FMT_RGBF);
	if(!img) {
		return false;
	}

	/* convert the pixels to linear color space */
	for(int i=0; i<xsz*ysz; i++) {
		img[i].x = pow(img[i].x, 2.2);
		img[i].y = pow(img[i].y, 2.2);
		img[i].z = pow(img[i].z, 2.2);
	}

	set_pixels(xsz, ysz, img);
	img_free_pixels(img);
	return true;
}


bool Image::save(const char *fname) const
{
	if(!pixels) {
		return false;
	}

	if(img_save_pixels(fname, pixels, xsz, ysz, IMG_FMT_RGBAF) == -1) {
		return false;
	}
	return true;
}
