#ifndef CAMERA_H_
#define CAMERA_H_

#include "vmath/vmath.h"

class Camera {
protected:
	Vector3 pos;
	float vfov;	// vertical field of view in radians

	mutable Matrix4x4 cached_matrix;
	mutable bool cached_matrix_valid;

	mutable Vector3 *rdir_cache;
	mutable int rdir_cache_width, rdir_cache_height;

	virtual void calc_matrix(Matrix4x4 *mat) const = 0;

	Vector2 calc_sample_pos(int x, int y, int xsz, int ysz, int sample) const;

public:
	Camera();
	Camera(const Vector3 &pos);
	virtual ~Camera();

	virtual void set_fov(float vfov);
	virtual float get_fov() const;

	virtual void set_position(const Vector3 &pos);
	virtual const Vector3 &get_position() const;
	virtual const Matrix4x4 &get_matrix() const;

	virtual Ray get_primary_ray(int x, int y, int xsz, int ysz, int sample = 0) const;
};

class TargetCamera : public Camera {
protected:
	Vector3 target;

	void calc_matrix(Matrix4x4 *mat) const;

public:
	TargetCamera();
	TargetCamera(const Vector3 &pos, const Vector3 &targ);

	virtual void set_target(const Vector3 &targ);
	virtual const Vector3 &get_target() const;
};

class FlyCamera : public Camera {
protected:
	Quaternion rot;

	void calc_matrix(Matrix4x4 *mat) const;

public:
	void input_move(float x, float y, float z);
	void input_rotate(float x, float y, float z);
};

#endif	// CAMERA_H_
