#include <float.h>
#include "box.h"

Box::Box()
	: min(-0.5, -0.5, -0.5), max(0.5, 0.5, 0.5)
{
}

Box::Box(const Vector3 &min_arg, const Vector3 &max_arg)
	: min(min_arg), max(max_arg)
{
}

bool Box::intersect(const Ray &inray, HitPoint *pt) const
{
	Ray ray = inray.transformed(inv_xform);

	Vector3 param[2] = {min, max};
	Vector3 inv_dir(1.0 / ray.dir.x, 1.0 / ray.dir.y, 1.0 / ray.dir.z);
	int sign[3] = {inv_dir.x < 0, inv_dir.y < 0, inv_dir.z < 0};

	float tmin = (param[sign[0]].x - ray.origin.x) * inv_dir.x;
	float tmax = (param[1 - sign[0]].x - ray.origin.x) * inv_dir.x;
	float tymin = (param[sign[1]].y - ray.origin.y) * inv_dir.y;
	float tymax = (param[1 - sign[1]].y - ray.origin.y) * inv_dir.y;

	pt->normal = Vector3(ray.origin.x > 0.0 ? 1 : -1, 0, 0);

	if(tmin > tymax || tymin > tmax) {
		return false;
	}
	if(tymin > tmin) {
		pt->normal = Vector3(0, ray.origin.y > 0.0 ? 1 : -1, 0);
		tmin = tymin;
	}
	if(tymax < tmax) {
		tmax = tymax;
	}

	float tzmin = (param[sign[2]].z - ray.origin.z) * inv_dir.z;
	float tzmax = (param[1 - sign[2]].z - ray.origin.z) * inv_dir.z;

	if(tmin > tzmax || tzmin > tmax) {
		return false;
	}
	if(tzmin > tmin) {
		pt->normal = Vector3(0, 0, ray.origin.z > 0.0 ? 1 : -1);
		tmin = tzmin;
	}
	if(tzmax < tmax) {
		tmax = tzmax;
	}

	float t = tmin < 1e-4 ? tmax : tmin;
	if(t >= 1e-4) {
		pt->obj = this;
		pt->dist = t;
		pt->pos = ray.origin + ray.dir * t;

		float min_dist = FLT_MAX;
		Vector3 offs = min + (max - min) / 2.0;
		Vector3 local_pt = pt->pos - offs;

		static const Vector3 axis[] = {
			Vector3{1, 0, 0}, Vector3{0, 1, 0}, Vector3{0, 0, 1}
		};
		int tcidx[][2] = {{2, 1}, {0, 2}, {0, 1}};

		for(int i=0; i<3; i++) {
			float dist = fabs((max[i] - offs[i]) - fabs(local_pt[i]));
			if(dist < min_dist) {
				min_dist = dist;
				pt->normal = axis[i] * (local_pt[i] < 0.0 ? 1.0 : -1.0);
				pt->texcoord = Vector2(pt->pos[tcidx[i][0]], pt->pos[tcidx[i][1]]);
			}
		}

		pt->pos.transform(xform);
		pt->normal.transform(dir_xform);
		pt->normal.normalize();
		return true;
	}
	return false;
}
